//###########################################################################
//					tHƑw{eBNXwȁ@{bǧK
//###########################################################################
//@{bǧKރLbg"NoribMp"e֐vO
//							2010/05/28	toadmaru@fuRo	
//							2010/06/01	h.yamato		motor funcs. added
//*********setting specifications    edited by oq 2010/7/21 
//4 dc motor
//3 servo
//0 speaker
//16 adc
//1 lcd out
//###########################################################################
#include "DSP28x_Project.h"
#include "NolibM.h"



/***************************************************/
/*	Eݒp֐							   */	
/***************************************************/
void initNolibM(void)
{
	InitSysCtrl();		// VXeRg[WX^iDSP2803x_SysCtrl.cj
	DeviceInit();		// F2803x foCXiDevInit_F2803x.cj
	InitCpuTimers();	// CPU timer iDSP2803x_CpuTimers.cj

	ConfigCpuTimer(&CpuTimer0, 60, 500000);
	ConfigCpuTimer(&CpuTimer1, 60, 50000);
	ConfigCpuTimer(&CpuTimer2, 60, 1000); //1[ms]waitp: CPU^C}[ݒiCPU^C}[QCCPUFreq=60MHzC1000[us]j
	CpuTimer0Regs.TCR.all = 0x4001; // Use write-only instruction to set TSS bit = 0
	CpuTimer1Regs.TCR.all = 0x4001; // Use write-only instruction to set TSS bit = 0 
	CpuTimer2Regs.TCR.all = 0x4001;	// Use write-only instruction to set TSS bit = 0
	
	// ŏɃXs[J[特oȂ悤PWM0Zbg
//	ePWM[3]->TBPRD = 0;//ePWM[4]->TBPRD = ePWM[5]->TBPRD = ePWM[6]->TBPRD = 0;
	
	// ŏɃ[^Ȃ悤ɃZbg
	motor( 0,MotCN3);
	motor( 0,MotCN4);
	motor( 0,MotCN5);
	motor( 0,MotCN6);
		
	EALLOW; // below registers are "protected", allow access.
	SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;  // Start ePWM timer
	EDIS;	// Disable register access
	
//***************************************************************************
// ADC INITIALISATION
//***************************************************************************

	EALLOW;
   // SysCtrlRegs.PCLKCR0.bit.ADCENCLK = 1;
   // (*Device_cal)();

	AdcRegs.ADCCTL1.bit.ADCREFSEL	= 0;
   	AdcRegs.ADCCTL1.bit.ADCBGPWD	= 1;	// Power up band gap
   	AdcRegs.ADCCTL1.bit.ADCREFPWD	= 1;	// Power up reference
   	AdcRegs.ADCCTL1.bit.ADCPWDN 	= 1;	// Power up rest of ADC
	AdcRegs.ADCCTL1.bit.ADCENABLE	= 1;	// Enable ADC
    asm(" RPT#100 || NOP");

	AdcRegs.ADCCTL1.bit.INTPULSEPOS	= 1;	// create int pulses 1 cycle prior to output latch

	// set S/H window to 6 clk cycles (117ns)
	AdcRegs.ADCSOC0CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC1CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC2CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC3CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC4CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC5CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC6CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC7CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC8CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC9CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC10CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC11CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC12CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC13CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC14CTL.bit.ACQPS = 6;
   	AdcRegs.ADCSOC15CTL.bit.ACQPS = 6;

//	AdcRegs.INTSEL1N2.bit.INT1SEL = 14;		// ADCCH14 (ADC-B6) EOC causes ADCInterrupt 1
//	AdcRegs.INTSEL1N2.bit.INT1CONT = 1;		// set ADCInterrupt 1 to auto clr
	AdcRegs.INTSEL1N2.bit.INT1CONT = 0;		// set ADCInterrupt 1 to auto clr
//	AdcRegs.INTSEL1N2.bit.INT1E = 1;		// enable ADC interrupt 1
	AdcRegs.INTSEL1N2.bit.INT1E = 0;		// enable ADC interrupt 1


//EOC = end of conversion event; SOC = start of conversion event
   	AdcRegs.ADCINTSOCSEL1.bit.SOC0 = 0;		// software trigger causes SOC0
   	AdcRegs.ADCINTSOCSEL1.bit.SOC1 = 0;
   	AdcRegs.ADCINTSOCSEL1.bit.SOC2 = 0;
   	AdcRegs.ADCINTSOCSEL1.bit.SOC3 = 0;
   	AdcRegs.ADCINTSOCSEL1.bit.SOC4 = 0;
   	AdcRegs.ADCINTSOCSEL1.bit.SOC5 = 0;
   	AdcRegs.ADCINTSOCSEL1.bit.SOC6 = 0;
   	AdcRegs.ADCINTSOCSEL1.bit.SOC7 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC8 = 0;   
   	AdcRegs.ADCINTSOCSEL2.bit.SOC9 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC10 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC11 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC12 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC13 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC14 = 0;
   	AdcRegs.ADCINTSOCSEL2.bit.SOC15 = 0;


// Select the channel to be converted when SOCx is received
	AdcRegs.ADCSOC0CTL.bit.CHSEL= 0;	// convert ADC-A0 (CH0) when SOC0 is received
	AdcRegs.ADCSOC1CTL.bit.CHSEL= 1;	// convert ADC-A1 (CH1) when SOC1 is received
	AdcRegs.ADCSOC2CTL.bit.CHSEL= 2;
	AdcRegs.ADCSOC3CTL.bit.CHSEL= 3;
	AdcRegs.ADCSOC4CTL.bit.CHSEL= 4;
	AdcRegs.ADCSOC5CTL.bit.CHSEL= 5;
	AdcRegs.ADCSOC6CTL.bit.CHSEL= 6;
	AdcRegs.ADCSOC7CTL.bit.CHSEL= 7;
	AdcRegs.ADCSOC8CTL.bit.CHSEL= 8;
	AdcRegs.ADCSOC9CTL.bit.CHSEL= 9;	// convert ADC-B1 (CH9) when SOC9 is received
	AdcRegs.ADCSOC10CTL.bit.CHSEL= 10;
	AdcRegs.ADCSOC11CTL.bit.CHSEL= 11;
	AdcRegs.ADCSOC12CTL.bit.CHSEL= 12;
	AdcRegs.ADCSOC13CTL.bit.CHSEL= 13;
	AdcRegs.ADCSOC14CTL.bit.CHSEL= 14;
	AdcRegs.ADCSOC15CTL.bit.CHSEL= 15;

	EDIS;	
	
	
	
	#ifdef FLASH
// Step 5. User specific code, enable interrupts:

// Copy time critical code and Flash setup code to RAM
// This includes the following ISR functions: epwm1_timer_isr(), epwm2_timer_isr()
// epwm3_timer_isr and and InitFlash();
// The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart
// symbols are created by the linker. Refer to the F2808.cmd file.
   MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);

// Call Flash Initialization to setup flash waitstates
// This function must reside in RAM
   InitFlash();
#endif

// LCD
 lcd_INIT();


}

/***************************************************/
/*	ADRo[^p֐								   */
/*	̓`l̓d0-4095̒lŕԂ@@@@@@@@@@@@@@@*/
/*    ch [range] 0-15							*/
/***************************************************/
Uint16 sensor(Uint16 ch)
{
volatile Uint16 *u2adcVals;
u2adcVals=&AdcResult.ADCRESULT0;
AdcRegs.ADCSOCFRC1.all = 0x0001<<ch;
return u2adcVals[ch];   		
}

/***************************************************/
/*	DC[^p֐F CW/CCW/BRAKE/FREE ̐ݒ			   */	
/***************************************************/
void setMotDir(Uint16 mode, Uint16 ch)
{
	if(ch==MotCN3){	// for U1/CN3 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO8   =1;
			GpioDataRegs.GPASET.bit.GPIO10  =1;
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO8   =1;
			GpioDataRegs.GPACLEAR.bit.GPIO10=1;
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPACLEAR.bit.GPIO8 =1;
			GpioDataRegs.GPASET.bit.GPIO10  =1;
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO8 =1;
			GpioDataRegs.GPACLEAR.bit.GPIO10=1;
		}
	}
	/**************************************************/
	if(ch==MotCN4){	// for U1/CN4 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO24  =1;
			GpioDataRegs.GPBSET.bit.GPIO34  =1;	
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO24  =1;
			GpioDataRegs.GPBCLEAR.bit.GPIO34=1;	
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPACLEAR.bit.GPIO24=1;
			GpioDataRegs.GPBSET.bit.GPIO34  =1;	
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO24=1;
			GpioDataRegs.GPBCLEAR.bit.GPIO34=1;	
		}
	}
	/**************************************************/

		if(ch==MotCN5){	// for U2/CN5 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO18  =1;
			GpioDataRegs.GPASET.bit.GPIO19  =1;	
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO18  =1;
			GpioDataRegs.GPACLEAR.bit.GPIO19=1;	
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPACLEAR.bit.GPIO18=1;
			GpioDataRegs.GPASET.bit.GPIO19  =1;	
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO18=1;
			GpioDataRegs.GPACLEAR.bit.GPIO19=1;	
		}
	}
	/**************************************************/
		if(ch==MotCN6){	// for U2/CN6 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO16  =1;
			GpioDataRegs.GPASET.bit.GPIO17  =1;	
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO16  =1;
			GpioDataRegs.GPACLEAR.bit.GPIO17=1;	
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPACLEAR.bit.GPIO16=1;
			GpioDataRegs.GPASET.bit.GPIO17  =1;	
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO16=1;
			GpioDataRegs.GPACLEAR.bit.GPIO17=1;	
		}
	}
#ifdef DUAL_DRIVE
/***************************************************/
/*   Revese Motor Driver Port Settings			   */
/***************************************************/
if(ch==RMotCN3){	// for U1/CN3 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO9   =1;
			GpioDataRegs.GPASET.bit.GPIO11  =1;
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO9   =1;
			GpioDataRegs.GPACLEAR.bit.GPIO11=1;
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPACLEAR.bit.GPIO9 =1;
			GpioDataRegs.GPASET.bit.GPIO11  =1;
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO9 =1;
			GpioDataRegs.GPACLEAR.bit.GPIO11=1;
		}
	}
	/**************************************************/
	if(ch==RMotCN4){	// for U1/CN4 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPBSET.bit.GPIO42  =1;
			GpioDataRegs.GPBSET.bit.GPIO44  =1;	
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPBSET.bit.GPIO42  =1;
			GpioDataRegs.GPBCLEAR.bit.GPIO44=1;	
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPBCLEAR.bit.GPIO42=1;
			GpioDataRegs.GPBSET.bit.GPIO44  =1;	
		}
		if(mode==3){// free mode
			GpioDataRegs.GPBCLEAR.bit.GPIO42=1;
			GpioDataRegs.GPBCLEAR.bit.GPIO44=1;	
		}
	}
	/**************************************************/

		if(ch==RMotCN5){	// for U2/CN5 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO26  =1;
			GpioDataRegs.GPASET.bit.GPIO27  =1;	
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO26  =1;
			GpioDataRegs.GPACLEAR.bit.GPIO27=1;	
		}
		if(mode==2){// CCW(or CW) mod
			GpioDataRegs.GPACLEAR.bit.GPIO26=1;
			GpioDataRegs.GPASET.bit.GPIO27  =1;	
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO26=1;
			GpioDataRegs.GPACLEAR.bit.GPIO27=1;	
		}
	}
/**************************************************/
		if(ch==RMotCN6){	// for U2/CN6 DC Motor
		if(mode==0){// Brake mode
			GpioDataRegs.GPASET.bit.GPIO12  =1;
			GpioDataRegs.GPASET.bit.GPIO13  =1;	
		}
		if(mode==1){// CW(or CCW) mode
			GpioDataRegs.GPASET.bit.GPIO12  =1;
			GpioDataRegs.GPACLEAR.bit.GPIO13=1;	
		}
		if(mode==2){// CCW(or CW) mode
			GpioDataRegs.GPACLEAR.bit.GPIO12=1;
			GpioDataRegs.GPASET.bit.GPIO13  =1;	
		}
		if(mode==3){// free mode
			GpioDataRegs.GPACLEAR.bit.GPIO12=1;
			GpioDataRegs.GPACLEAR.bit.GPIO13=1;	
		}
	}
#endif
	
	
	
}
/***************************************************/
/*	DC[^p֐F PWM Duty@̐ݒ					   */	
/***************************************************/
void setMotSpd(Uint16 comp, Uint16 ch)
{
	if(comp> 100){comp=100;}
	if(ch<8)
	{
		ePWM[ch]->TBPRD = 150;
		ePWM[ch]->CMPA.half.CMPA = comp;
	}
	else
	{
		ePWM[ch-7]->TBPRD = 150;
		ePWM[ch-7]->CMPB = comp;	
	}
}
/***************************************************/
/*	DC[^p֐									   */	
/***************************************************/
void motor(int16 speed, Uint16 ch)
{	
	if(speed==0)		{setMotDir(0,ch); setMotSpd(0,ch);}
	if(speed>0)			{setMotDir(1,ch); setMotSpd(+speed,ch);}
	if(speed<0)			{setMotDir(2,ch); setMotSpd(-speed,ch);}
	if(speed==MotFree)	{setMotDir(3,ch); setMotSpd(0,ch);}
}
/***************************************************/
/*	T[{[^p֐ val:[-100 100]->comp:[1150 4550] */	
/***************************************************/
void servo(int16 val, Uint16 ch)
{
	Uint16 comp = (Uint16)(val*17+2850);
	if(comp>4550){comp=4550;}
	if(comp<1150){comp=1150;}

//PWMxB => CN16/CN14/JP3 available
//PWMxA => JP4 available

	if(ch<8)
	{
		ePWM[ch]->TBPRD = 37800;
		ePWM[ch]->CMPA.half.CMPA = comp;
	}
	else
	{
		ePWM[ch-7]->TBPRD = 37800;
		ePWM[ch-7]->CMPB = comp;
	}	
}
/***************************************************/
/*	I/O{[hSW1p֐								   */	
/***************************************************/
unsigned char sw1(unsigned char i)
{
	if(i == GpioDataRegs.GPADAT.bit.GPIO31)
		return(1);
	else
		return(0);	
}
/***************************************************/
/*	I/O{[hSW2p֐								   */	
/***************************************************/
unsigned char sw2(unsigned char i)
{
	if(i == GpioDataRegs.GPADAT.bit.GPIO30)
		return(1);
	else
		return(0);	
}
/***************************************************/
/*	LEDŊ֐									   */	
/***************************************************/
void ledFlash(unsigned char command, Uint16 ch)
{
	if(command==TOGGLE)
	{
		switch(ch)
		{
			case 1:
				GpioDataRegs.GPATOGGLE.bit.GPIO1 = 1;
				break;
			case 2:
				GpioDataRegs.GPATOGGLE.bit.GPIO3 = 1;
				break;
			case 3:
				GpioDataRegs.GPBTOGGLE.bit.GPIO41 = 1;
				break;
			case 4:
				GpioDataRegs.GPBTOGGLE.bit.GPIO40 = 1;
				break;
			default:
				break;
		}
	}
	else
	{
		switch(ch)
		{
			case 1:
				GpioDataRegs.GPADAT.bit.GPIO1 = !command;
				break;
			case 2:
				GpioDataRegs.GPADAT.bit.GPIO3 = !command;
				break;
			case 3:
				GpioDataRegs.GPBDAT.bit.GPIO41 = !command;
				break;
			case 4:
				GpioDataRegs.GPBDAT.bit.GPIO40 = !command;
				break;
			default:
				break;
		}
	}
}

/***************************************************/
/*	P[ms]EFCg֐								   */
/***************************************************/
void wait(Uint16 ms)
{
	Uint16 i;
	for(i=0;i<ms;i++){
		CpuTimer2Regs.TCR.bit.TIF = 1;
		while(CpuTimer2Regs.TCR.bit.TIF != 1);
	}
}

/***************************************************/
/*	Xs[J[p֐P								   */	
/***************************************************/
void beep2(Uint16 f, Uint16 ch)
{
	if(ch<8)
	{
		ePWM[ch]->TBPRD = f;
		ePWM[ch]->CMPA.half.CMPA = f / 2;			
	}
	else
	{
		ePWM[ch]->TBPRD = f;
		ePWM[ch]->CMPB = f / 2;
	}
}

/***************************************************/
/*	Xs[J[p֐QiԎw肠j					   */	
/***************************************************/
void beep(Uint16 f, Uint16 ch, Uint16 ms)
{
	beep2(f, ch);
	wait(ms);
	beep2(0, ch);
}

/***************************************************/
/*	Xs[J[p֐QiԎw肠j					   */	
/***************************************************/
void mario(void)
{
	unsigned int part = 1;
	unsigned int cnt = 1;
	
	CpuTimer0Regs.PRD.all =  100000;
	CpuTimer0Regs.TCR.bit.TIF = 1;
	while(part <= 2){
		if(CpuTimer0Regs.TCR.bit.TIF == 1){
			CpuTimer0Regs.TCR.bit.TIF = 1;
				switch(part){
					case 1:
						if(400 < cnt && cnt < 450){
							beep2(SHI, 3);
						//	beep2(SO, 4);
						}else if(500 < cnt && cnt < 650){
							beep2((FA / 2), 3);
						//	beep2((RE / 2), 4);
						}else if(700 < cnt && cnt < 750){
							beep2((FA / 2), 3);
						//	beep2((RE / 2), 4);
						}else if(800 < cnt && cnt < 883){
							beep2((FA / 2), 3);
						//	beep2((RE / 2), 4);
						}else if(933 < cnt && cnt < 1016){
							beep2((MI / 2), 3);
						//	beep2((DO / 2), 4);
						}else if(1066 < cnt && cnt < 1150){
							beep2((RE / 2), 3);
						//	beep2(SHI, 4);
						}else if(1200 < cnt && cnt < 1550){
							beep2((DO / 2), 3);
						//	beep2(SO, 4);
						}else{
							beep2(0, 3);
						//	beep2(0, 4);
						}
				/*		if(400 < cnt && cnt < 450)
							beep2((MI / 2), 5);
						else if(500 < cnt && cnt < 650)
							beep2((MI / 2), 5);
						else if(700 < cnt && cnt < 750)
							beep2((MI / 2), 5);
						else if(800 < cnt && cnt < 883)
							beep2((MI / 2), 5);
						else if(933 < cnt && cnt < 1016)
							beep2((FA / 2), 5);
						else if(1066 < cnt && cnt < 1150)
							beep2((SO / 2), 5);
						else if(1200 < cnt && cnt < 1250)
							beep2((RA / 2), 5);
						else if(1300 < cnt && cnt < 1450)
							beep2((MI / 2), 5);
						else if(1500 < cnt && cnt < 1550)
							beep2((MI / 2), 5);
						else
							beep2(0, 5);
						break;
					case 2:
						if(cnt < 350)
//							beep2(RA, 5);
							beep2(0, 5);
						else
							beep2(0, 5);
						break;
				*/
				}
				cnt++;
				if(cnt == 1600){
				cnt = 1;
				part++;
			}
		}
	}
}
/***********************************************/
/*              LCD CONTROL FUNCTION           */
/***********************************************/
// SC1602B-piccolo connection
// 1 Vdd 
// 2 GND
// 3 Vo
// 4 RS GPIO15
// 5 R/W GND
// 6 E GPIO14
// 7 DB0 N.C.
// 8 DB1 N.C.
// 9 DB2 N.C.
// 10 DB3 N.C.
// 11 DB4 GPIO25
// 12 DB5 GPIO43
// 13 DB6 GPIO32
// 14 DB7 GPIO33

void setD(char x)
{
		GpioDataRegs.GPADAT.bit.GPIO25 = (0x01&x);
	
	if((0x01&x)==1)
		{
		GpioDataRegs.GPASET.bit.GPIO25=1;
		}
	else
		{
		GpioDataRegs.GPACLEAR.bit.GPIO25=1;
		}

	if(((0x02&x)>>1)==1)
		{
		GpioDataRegs.GPBSET.bit.GPIO43=1;
		}
	else
		{
		GpioDataRegs.GPBCLEAR.bit.GPIO43=1;
		}

	if(((0x04&x)>>2)==1)
		{
		GpioDataRegs.GPBSET.bit.GPIO32=1;
		}
	else
		{
		GpioDataRegs.GPBCLEAR.bit.GPIO32=1;
		}

	if(((0x08&x)>>3)==1)
		{
		GpioDataRegs.GPBSET.bit.GPIO33=1;
		}
	else
		{
		GpioDataRegs.GPBCLEAR.bit.GPIO33=1;
		}
}
// 4bit
void send4bit(unsigned char c)
{
    setE();
    setD(c);
    clrE();
}

// 8bit
void send(unsigned char c)
{
    send4bit(c >> 4);
    send4bit(c);
  	wait(1);
}

//\
void lcd_PUTS(unsigned char *msg)
{
	int i;
    // bZ[Wo
    for(i = 0; msg[i] != '\0'; i++){
        if(i == 16){
    lcd_LF(); //s
        }
        lcd_SEND(msg[i]);
        //wait(500);         
    }
}

// LCD
void lcd_INIT(void)
{
    cmd_mode();
    clrE();

    wait(20);      // 15ms҂
    send4bit(3);       // function set 8bit mode
    wait(5);        // 4.1msȏ҂
    send4bit(3);       // function set 8bit mode
    wait(1);        // 100usȏ҂
    send4bit(3);       // function set 8bit mode
    wait(5);        // 4.1msȏ҂
    send4bit(2);       // function set 4bit mode
    wait(1);        // 40usȏ҂
    send(0x28);        // function set 4bit 2line
    wait(1);        // 40usȏ҂
    send(0x08);        // display off
    wait(1);        // 40usȏ҂
    send(0x0F);        // 
    wait(1);
    send(0x06);        // entry mode
    wait(1);

}


